---
generated_at: 2026-01-21 19:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-Long Path有効化失敗通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/GlobalClass.vb` 行1770-1789（Long Path処理）
- E-02: `Source/General/GlobalClass.vb` 行1780（MsgError呼び出し - 終了コードエラー）
- E-03: `Source/General/GlobalClass.vb` 行1784（MsgError呼び出し - 例外）
- E-04: `Source/General/General.vb` 行1222-1241（MsgError関数定義）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行28（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Something went wrong, the Long Path Support was not enabled!」を含む | E-02 (行1780), E-03 (行1784) | ○ |
| C-02 | MsgError関数でエラーダイアログを表示する | E-02, E-03, E-04 | ○ |
| C-03 | 例外発生時はex.Messageが追加表示される | E-03 (行1784) | ○ |
| C-04 | regProcess.ExitCode <> 0で判定する | E-01 (行1779) | ○ |
| C-05 | reg.exeでレジストリ操作を行う | E-01 (行1770-1771) | ○ |
| C-06 | Verb = "runas"で管理者権限を要求する | E-01 (行1772) | ○ |
| C-07 | Ignoreを選択するとs.CheckForLongPathSupport = Falseになる | E-01 (行1787) | ○ |
| C-08 | レジストリ操作関連の通知である | E-05 (行28備考) | ○ |
| C-09 | 通知カテゴリは「Long Path有効化失敗通知」である | E-05 (行28) | ○ |
| C-10 | WaitForExitでプロセス完了を待機する | E-01 (行1777) | ○ |
| C-11 | Try-Catchで例外をハンドリングする | E-01 (行1783) | ○ |
| C-12 | LongPathsEnabledキーを設定する | E-01 (行1771) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalClass.vb 行1770-1789の実装が設計書の記述と一致しているか確認
- [ ] reg.exeの引数が正しいか確認
- [ ] CheckForLongPathSupportの永続化が正しく行われているか確認
